<?php

/**
 * Fired during plugin deactivation
 *
 * @link       https://wwdh.de
 * @since      1.0.0
 *
 * @package    Wp_Oauth2_Client
 * @subpackage Wp_Oauth2_Client/includes
 */

/**
 * Fired during plugin deactivation.
 *
 * This class defines all code necessary to run during the plugin's deactivation.
 *
 * @since      1.0.0
 * @package    Wp_Oauth2_Client
 * @subpackage Wp_Oauth2_Client/includes
 * @author     Jens Wiecker <plugin@wwdh.de>
 */
class Wp_Oauth2_Client_Deactivator {

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.0.0
	 */
	public static function deactivate() {
		delete_option('wp_oauth2_client_settings');
		delete_option('wp-oauth2-client/oauth_api_data');
        delete_option('wp-oauth2-client/config');
        delete_option('wp_oauth2_client_settings');
        delete_option('wp-oauth2-client/access_token');
        delete_option('wp-oauth2-client/refresh_token');
        delete_option('wp-oauth2-client/lizenz_data');
        delete_option('wp-oauth2-client/user_license_data');
        delete_option('wp-oauth2-client/lizenz_products');
	}

}
