<?php

namespace WPOauth2\Client;

use stdClass;
use Wp_Oauth2_Client;


defined('ABSPATH') or die();

class OAuth2_Sync_Cronjob
{

    use OauthSettings;

    /**
     * @access   private
     * @var      array $settings The FB-API Settings for this Plugin
     */
    private array $settings;

    private string $basename;

    /**
     * @access   private
     * @var Wp_Oauth2_Client $main The main class.
     */
    private Wp_Oauth2_Client $main;

    public function __construct(string $basename, Wp_Oauth2_Client $main)
    {

        $this->main = $main;
        $this->basename = $basename;
        if (!get_option('wp_oauth2_client_settings')) {
            $settings = $this->get_oauth_defaults('oauth_settings');
            update_option('wp_oauth2_client_settings', $settings);
        }
        $this->settings = get_option('wp_oauth2_client_settings');
        if ($this->settings) {
            if ($this->settings['oauth2_cron_aktiv']) {
                if (!wp_next_scheduled('wp_oauth_client_sync')) {
                    wp_schedule_event(time(), $this->settings['cron_sync_interval'], 'wp_oauth_client_sync');
                }
            }
        }
    }

    public function fn_oath2_client_wp_un_schedule_task($args): void
    {
        $timestamp = wp_next_scheduled('wp_oauth_client_sync');
        wp_unschedule_event($timestamp, 'wp_oauth_client_sync');
    }

    public function fn_oath2_client_wp_delete_task($args): void
    {
        wp_clear_scheduled_hook('wp_oauth_client_sync');
    }

    public function fn_oath2_client_run_schedule_task($args): void
    {

        if ($this->settings) {
            $schedule = $this->settings['cron_sync_interval'];
        } else {
            $schedule = 'daily';
        }
        $time = get_gmt_from_date(gmdate('Y-m-d H:i:s', current_time('timestamp')), 'U');
        $args = [
            'timestamp' => $time,
            'recurrence' => (string) $schedule->recurrence,
            'hook' => 'wp_oauth_client_sync'
        ];

        $this->schedule_task($args);
    }

    /**
     * @param $task
     * @return void
     */
    private function schedule_task($task): void
    {

        /* Must have task information. */
        if (!$task) {
            return;
        }

        /* Set list of required task keys. */
        $required_keys = array(
            'timestamp',
            'recurrence',
            'hook'
        );

        /* Verify the necessary task information exists. */
        $missing_keys = [];
        foreach ($required_keys as $key) {
            if (!array_key_exists($key, $task)) {
                $missing_keys[] = $key;
            }
        }

        /* Check for missing keys. */
        if (!empty($missing_keys)) {
            return;
        }

        /* Task darf nicht bereits geplant sein. */
        if (wp_next_scheduled($task['hook'])) {
            wp_clear_scheduled_hook($task['hook']);
        }

        /* Schedule the task to run. */
        wp_schedule_event($task['timestamp'], $task['recurrence'], $task['hook']);
    }

}
