<?php

namespace WPOauth2\Client;

use WPOauth2\Client\Oauth_Client_Callback;
use Wp_Oauth2_Client;
use WP_Query;

class WP_Oauth_Helper {
	private static $instance;

	use OauthSettings;

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $basename The ID of this plugin.
	 */
	private string $basename;

	/**
	 * The Version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string $version The current Version of this plugin.
	 */
	private string $version;

	/**
	 * Store plugin main class to allow public access.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var Wp_Oauth2_Client $main The main class.
	 */
	private Wp_Oauth2_Client $main;

	/**
	 * Store plugin helper class.
	 *
	 * @param string $basename
	 * @param string $version
	 *
	 * @since    1.0.0
	 * @access   private
	 *
	 * @var Wp_Oauth2_Client $main
	 */

	/**
	 * @return static
	 */
	public static function instance( string $version, string $basename, Wp_Oauth2_Client $main ): self {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self( $version, $basename, $main );
		}

		return self::$instance;
	}

	public function __construct( string $version, string $basename, Wp_Oauth2_Client $main ) {
		$this->main     = $main;
		$this->version  = $version;
		$this->basename = $basename;
	}

	public function set_client_scopes($scopes)
	{
		$scopeArr = [];
		$settings = get_option( 'wp_oauth2_client_settings' );
		foreach ($this->get_oauth_defaults('oauth_scopes') as $tmp){
			$settings[$tmp['value']] =  0;
		}

		foreach ($scopes as $tmp){
			$scope = $this->get_oauth_defaults('oauth_scopes', false, $tmp);
			if($scope){
				$settings[$scope['value']] = 1;
			}
			$scopeArr[] = $tmp;
		}
		$settings['client_scopes'] = implode(' ', $scopeArr);
		update_option('wp_oauth2_client_settings', $settings);
	}

	public function set_default_oauth2_client_data():void {

		//delete_option('wp_oauth2_client_settings');
		if ( ! get_option( 'wp_oauth2_client_settings' ) ) {
			update_option( 'wp_oauth2_client_settings', $this->get_oauth_defaults( 'oauth_settings' ) );
		}
	}

	public function fn_oauth2_client_current_theme_directory(): string {
		$current_theme_dir = '';
		$current_theme     = wp_get_theme();
		if ( $current_theme->exists() && $current_theme->parent() ) {
			$parent_theme = $current_theme->parent();
			if ( $parent_theme->exists() ) {
				$current_theme_dir = $parent_theme->get_stylesheet();
			}
		} elseif ( $current_theme->exists() ) {
			$current_theme_dir = $current_theme->get_stylesheet();
		}

		return $current_theme_dir;
	}

	public function fnPregWhitespace( $string ): string {
		if ( ! $string ) {
			return '';
		}

		return trim( preg_replace( '/\s+/', ' ', $string ) );
	}
}